/*
 * Decompiled with CFR 0.152.
 */
package net.mw3.etewt3.utils;

public class Vector {
    public static float toRadian(float degree) {
        return (float)((double)degree * (Math.PI / 180));
    }

    public static float toDegree(float radian) {
        return (float)((double)radian * 57.29577951308232);
    }

    public static float[] normalize(float[] a) {
        float len = Vector.length(a);
        return new float[]{a[0] / len, a[1] / len, a[2] / len};
    }

    public static float length(float[] v) {
        return Vector.length(v[0], v[1], v[2]);
    }

    public static float length(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static float dotProduct(float[] v1, float[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static float angleNormalize180(float angle) {
        if ((double)(angle = Vector.angleNormalize360(angle)) > 180.0) {
            angle -= 360.0f;
        }
        return angle;
    }

    public static float angleNormalize360(float angle) {
        return 0.005493164f * (float)((int)((double)angle * 182.04444444444445) & 0xFFFF);
    }

    public static void angleVectors(float[] angles, float[] forward, float[] right, float[] up) {
        float num = angles[1] * 0.01745329f;
        float num4 = (float)Math.sin(num);
        float num7 = (float)Math.cos(num);
        num = angles[2] * 0.01745329f;
        float num3 = (float)Math.sin(num);
        float num6 = (float)Math.cos(num);
        num = angles[0] * 0.01745329f;
        float num2 = (float)Math.sin(num);
        float num5 = (float)Math.cos(num);
        if (forward[0] != 0.0f) {
            forward[0] = num6 * num7;
            forward[1] = num6 * num4;
            forward[2] = -num3;
        }
        if (right[0] != 0.0f) {
            right[0] = -1.0f * num2 * num3 * num7 + -1.0f * num5 * -num4;
            right[1] = -1.0f * num2 * num3 * num4 + -1.0f * num5 * num7;
            right[2] = -1.0f * num2 * num6;
        }
        if (up[0] != 0.0f) {
            up[0] = num5 * num3 * num7 + -num2 * -num4;
            up[1] = num5 * num3 * num4 + -num2 * num7;
            up[2] = num5 * num6;
        }
    }

    public static int[] radar(int[] screen, float[] vLocal, float[] vEnemy, float[] vRotation) {
        float[] v = new float[3];
        float[] angles = new float[3];
        float[] right = new float[3];
        v = Vector.vectorSubtract(vEnemy, vLocal);
        v[2] = 0.0f;
        float s = Vector.vectorLength(v) * 0.025f;
        Vector.vectoangles(v, angles);
        angles[1] = Vector.angleNormalize180(angles[1] - vRotation[1]);
        Vector.angleVectors(angles, v, right, right);
        v = Vector.vectorScale(v, s);
        if (v[0] > 76.0f) {
            v = Vector.vectorScale(v, 76.0f / v[0]);
        } else if (v[0] < -76.0f) {
            v = Vector.vectorScale(v, -76.0f / v[0]);
        }
        if (v[1] > 76.0f) {
            v = Vector.vectorScale(v, 76.0f / v[1]);
        } else if (v[1] < -76.0f) {
            v = Vector.vectorScale(v, -76.0f / v[1]);
        }
        screen[0] = (int)(-v[1]);
        screen[1] = (int)(-v[0]);
        return screen;
    }

    public static void vectoangles(float[] value1, float[] angles) {
        float num3;
        float num2;
        if (value1[1] == 0.0f && value1[0] == 0.0f) {
            num2 = 0.0f;
            num3 = value1[2] > 0.0f ? 90.0f : 270.0f;
        } else {
            float num;
            num2 = value1[0] != 0.0f ? (float)(Math.atan2(value1[1], value1[0]) * 180.0 / Math.PI) : (value1[1] > 0.0f ? 90.0f : 270.0f);
            if (num2 < 0.0f) {
                num2 += 360.0f;
            }
            if ((num3 = (float)(Math.atan2(value1[2], num = (float)Math.sqrt(value1[0] * value1[0] + value1[1] * value1[1])) * 180.0 / Math.PI)) < 0.0f) {
                num3 += 360.0f;
            }
        }
        angles[2] = -num3;
        angles[1] = num2;
        angles[0] = 0.0f;
    }

    public static float vectorLength(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static float[] vectorScale(float[] v, float s) {
        return new float[]{v[0] * s, v[1] * s, v[2] * s};
    }

    public static float[] vectorSubtract(float[] a, float[] b) {
        return new float[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
    }
}

