/*
 * Decompiled with CFR 0.152.
 */
package net.mw3.etewt3.script;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.mw3.etewt3.WIN.OverlayHack;
import net.mw3.etewt3.handlers.PaintListener;
import net.mw3.etewt3.plugin.PluginLoader;
import net.mw3.etewt3.script.ScriptEngine;

public class ScriptHandler {
    private HashMap<Integer, ScriptEngine> scripts = new HashMap();
    private HashMap<Integer, Thread> scriptThreads = new HashMap();
    private final PluginLoader<ScriptEngine> scriptLoader;

    public ScriptHandler(File workDir) {
        this.scriptLoader = new PluginLoader<ScriptEngine>(ScriptEngine.class, new File(workDir, "Scripts"), false, false, "ScriptLoader", null);
    }

    private void addScriptToPool(ScriptEngine ss, Thread t) {
        int off = 0;
        while (off < this.scripts.size()) {
            if (!this.scripts.containsKey(off)) {
                this.scripts.put(off, ss);
                ss.ID = off;
                this.scriptThreads.put(off, t);
                return;
            }
            ++off;
        }
        ss.ID = this.scripts.size();
        this.scripts.put(this.scripts.size(), ss);
        this.scriptThreads.put(this.scriptThreads.size(), t);
    }

    public Map<Integer, ScriptEngine> getRunningScripts() {
        return Collections.unmodifiableMap(this.scripts);
    }

    public ScriptEngine getScriptForName(String name) {
        return this.scriptLoader.getInstanceForName(name);
    }

    public Collection<String> getScriptNames() {
        return this.scriptLoader.getClassNames();
    }

    public Collection<ScriptEngine> getScripts() {
        return this.scriptLoader.getObjects();
    }

    public void pauseScript(int id) {
        ScriptEngine s = this.scripts.get(id);
        s.isPaused = !s.isPaused;
    }

    public void reload() {
        this.reloadScripts();
    }

    public void reloadScripts() {
        this.scriptLoader.reload();
    }

    public void removeScript(int id) {
        if (this.scripts.get(id) == null) {
            return;
        }
        this.scripts.get((Object)Integer.valueOf((int)id)).isActive = false;
        this.scripts.remove(id);
        this.scriptThreads.remove(id);
    }

    public void runScript(final ScriptEngine ss) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ss.run();
            }
        }, "Script-" + ss.getName());
        if (ss instanceof PaintListener) {
            OverlayHack.register((PaintListener)((Object)ss));
        }
        this.addScriptToPool(ss, t);
        t.start();
    }

    public void stopAllScripts() {
        Thread curThread = Thread.currentThread();
        int i = 0;
        while (i < this.scripts.size()) {
            if (this.scripts.get(i) != null && this.scripts.get((Object)Integer.valueOf((int)i)).isActive) {
                if (this.scriptThreads.get(i) == curThread) {
                    this.removeScript(i);
                    curThread = null;
                } else {
                    this.stopScript(i);
                }
            }
            ++i;
        }
        if (curThread == null) {
            throw new ThreadDeath();
        }
    }

    public void stopScript(int id) {
        this.scripts.get((Object)Integer.valueOf((int)id)).isActive = false;
        this.scripts.remove(id);
        this.scriptThreads.get(id).stop();
        this.scriptThreads.remove(id);
    }
}

