/*
 * Decompiled with CFR 0.152.
 */
package net.mw3.etewt3.script;

import java.util.EventListener;
import java.util.logging.Level;
import net.mw3.etewt3.script.Scriptable;

public abstract class ScriptEngine
extends Scriptable
implements EventListener {
    public int ID = -1;
    public volatile boolean isActive = false;
    public volatile boolean isPaused = false;

    public abstract int loop() throws Exception;

    public abstract boolean onStart();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        this.log.info("Script started.");
        boolean start = false;
        try {
            start = this.onStart();
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "Error starting script: ", e);
        }
        if (!start) {
            this.log.severe("Failed to start up.");
            return;
        }
        this.isActive = true;
        try {
            while (this.isActive) {
                if (!this.isPaused && this.inMatch()) {
                    int timeOut = -1;
                    try {
                        timeOut = this.loop();
                    }
                    catch (ThreadDeath td) {
                        break;
                    }
                    catch (Throwable e) {
                        this.log.log(Level.WARNING, "Uncaught exception from script: ", e);
                    }
                    if (timeOut == -1) break;
                    try {
                        this.sleep(timeOut);
                        continue;
                    }
                    catch (ThreadDeath td) {
                        break;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                try {
                    this.sleep(1000);
                }
                catch (ThreadDeath td) {
                    break;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    break;
                }
            }
            try {
                this.onFinish();
            }
            catch (ThreadDeath e) {
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        catch (ThreadDeath td) {
            this.onFinish();
        }
        this.isActive = false;
        this.log.info("Script stopped.");
    }

    private void onFinish() {
    }
}

