/*
 * Decompiled with CFR 0.152.
 */
package net.mw3.etewt3.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.mw3.etewt3.plugin.NonPluginClass;
import net.mw3.etewt3.plugin.PermissionUCL;

public class PluginLoader<T> {
    private final Map<String, Class<? extends T>> classes;
    private final Class<T> extendClass;
    private final boolean init;
    private final Map<String, T> objects;
    private final PermissionCollection permissionCollection;
    private final File pluginDir;
    private final boolean singleton;
    private final Logger log;

    public PluginLoader(Class<T> extendClass, File pluginDir, boolean init, boolean singleton, String logName, PermissionCollection pc) {
        this.log = Logger.getLogger(logName);
        this.extendClass = extendClass;
        this.pluginDir = pluginDir;
        this.init = init;
        this.singleton = singleton;
        this.permissionCollection = pc;
        this.classes = new HashMap<String, Class<? extends T>>();
        this.objects = new HashMap<String, T>();
    }

    public Collection<T> getCachedObjects() {
        return Collections.unmodifiableCollection(this.objects.values());
    }

    public Collection<Class<? extends T>> getClasses() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Class<? extends T> getClassForName(String name) {
        return this.classes.get(name);
    }

    public Collection<String> getClassNames() {
        return Collections.unmodifiableCollection(this.classes.keySet());
    }

    public T getInstanceForName(String name) {
        Class<T> c;
        block6: {
            if (this.singleton && this.objects.get(name) != null) {
                return this.objects.get(name);
            }
            c = this.getClassForName(name);
            if (c != null) break block6;
            return null;
        }
        try {
            T t = c.newInstance();
            if (this.singleton) {
                this.objects.put(name, t);
            }
            return t;
        }
        catch (LinkageError noSuchMethodError) {
            this.log.log(Level.SEVERE, "Failed initialising class [" + name + "] due to : ", noSuchMethodError);
            this.log.severe("Suggest recompiling.");
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return null;
    }

    public List<T> getNewLoadedObjects() {
        if (this.singleton) {
            throw new RuntimeException("Cannot get new instance of singleton!");
        }
        ArrayList<T> out = new ArrayList<T>();
        for (Class<T> c : this.classes.values()) {
            try {
                out.add(c.newInstance());
            }
            catch (InstantiationException e) {
                this.log.log(Level.SEVERE, "Faild initing class " + c.getName(), e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.log.log(Level.SEVERE, "Faild initing class " + c.getName(), e);
                return null;
            }
        }
        return out;
    }

    public Collection<T> getObjects() {
        if (this.singleton) {
            if (!this.init) {
                for (String name : this.getClassNames()) {
                    this.getInstanceForName(name);
                }
            }
            return this.getCachedObjects();
        }
        Collection<String> names = this.getClassNames();
        ArrayList<T> objects = new ArrayList<T>(names.size());
        for (String name : names) {
            System.out.println(name);
            T t = this.getInstanceForName(name);
            if (t == null) continue;
            objects.add(t);
        }
        return objects;
    }

    private void load(URLClassLoader loader, String name) {
        Class<?> c;
        try {
            c = loader.loadClass(name);
        }
        catch (LinkageError noSuchMethodError) {
            this.log.log(Level.SEVERE, "Failed initialising class [" + name + "] due to : ", noSuchMethodError);
            this.log.severe("Suggest recompiling.");
            return;
        }
        catch (ClassNotFoundException e) {
            this.log.log(Level.SEVERE, "Failed initialising class [" + name + "] due to : ", e);
            return;
        }
        if (NonPluginClass.class.isAssignableFrom(c)) {
            return;
        }
        if (!this.extendClass.isAssignableFrom(c)) {
            this.log.warning("Class " + name + " does not extend the correct class.\nIf you are a script writer " + "and this class is not a script you need either put the class in " + "the same block of code as the script and make it non-static or " + "implement net.mw3.etewt3.plugin.NonPluginClass.");
            return;
        }
        Class<T> subClass = c.asSubclass(this.extendClass);
        this.classes.put(c.getName(), subClass);
        if (this.init) {
            try {
                this.objects.put(c.getName(), subClass.newInstance());
            }
            catch (InstantiationException e) {
                this.log.log(Level.SEVERE, "Faild initing class " + c.getName(), e);
                return;
            }
            catch (IllegalAccessException e) {
                this.log.log(Level.SEVERE, "Faild initing class " + c.getName(), e);
                return;
            }
        }
    }

    public void reload() {
        PermissionUCL loader;
        String loadedNames = null;
        ArrayList<String> loaded_names = new ArrayList<String>();
        this.classes.clear();
        this.objects.clear();
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(this.pluginDir);
        File[] dirArray = this.pluginDir.listFiles();
        if (dirArray == null) {
            this.log.severe("Attempting to load from [" + this.pluginDir + "] but it does not exist.");
            return;
        }
        File[] fileArray = dirArray;
        int n = dirArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory() && dir.getName().charAt(0) != '.') {
                dirs.add(dir);
            }
            ++n2;
        }
        try {
            URL[] urls = new URL[dirs.size()];
            int i = 0;
            while (i < dirs.size()) {
                urls[i] = ((File)dirs.get(i)).toURI().toURL();
                ++i;
            }
            loader = new PermissionUCL(urls, this.permissionCollection);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        for (File dir : dirs) {
            String[] stringArray = dir.list();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                if (name.endsWith(".class") && !name.contains("$")) {
                    name = name.substring(0, name.length() - ".class".length());
                    if (loadedNames == null) {
                        loadedNames = name;
                    } else if (loadedNames.length() > 40) {
                        loaded_names.add(loadedNames);
                        loadedNames = null;
                    } else {
                        loadedNames = String.valueOf(loadedNames) + ", " + name;
                    }
                    this.load(loader, name);
                }
                ++n4;
            }
        }
        int size = this.classes.size();
        this.log.info(String.format("Loaded %d class%s.", size, size == 1 ? "" : "es"));
        for (String name : loaded_names) {
            this.log.info("       " + name);
        }
    }
}

